<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:32.153506927 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A710" />
    <supported-cpuid id="Cortex-X2" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA710CPU_CYCLES &gt; 0), min(($BackendBoundCortexA710STALL_SLOT_BACKEND / (5 * $BackendBoundCortexA710CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundCortexA710STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA710STALL_BACKEND_MEM / $BackendMemoryBoundCortexA710STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA710CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA710STALL_BACKEND / $BackendStalledCyclesCortexA710CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA710INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA710ISB_SPEC + $BarrierOperationsPercentageCortexA710DSB_SPEC) + $BarrierOperationsPercentageCortexA710DMB_SPEC) / $BarrierOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA710BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA710BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA710BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA710INST_RETIRED &gt; 0), (($BranchMPKICortexA710BR_MIS_PRED_RETIRED / $BranchMPKICortexA710INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA710INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA710BR_IMMED_SPEC + $BranchOperationsPercentageCortexA710BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA710INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA710CPU_CYCLES / $CyclesPerInstructionCortexA710INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA710INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA710CRYPTO_SPEC / $CryptoOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA710INST_RETIRED &gt; 0), (($DTLBMPKICortexA710DTLB_WALK / $DTLBMPKICortexA710INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA710L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA710DTLB_WALK / $DTLBWalkPercentageCortexA710L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Half Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA710INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA710FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA710INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Single Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA710INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA710FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA710INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Double Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA710INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA710FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA710INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by any instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($FloatingPointOperationsPerCycleCortexA710CPU_CYCLES &gt; 0), (($FloatingPointOperationsPerCycleCortexA710FP_SCALE_OPS_SPEC + $FloatingPointOperationsPerCycleCortexA710FP_FIXED_OPS_SPEC) / $FloatingPointOperationsPerCycleCortexA710CPU_CYCLES), 0)" name="Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA710CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA710STALL_FRONTEND / $FrontendStalledCyclesCortexA710CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA710INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA710DP_SPEC - $IntegerOperationsPercentageCortexA710DSB_SPEC) / $IntegerOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA710CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA710INST_RETIRED / $InstructionsPerCycleCortexA710CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA710INST_RETIRED &gt; 0), (($ITLBMPKICortexA710ITLB_WALK / $ITLBMPKICortexA710INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA710L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA710ITLB_WALK / $ITLBWalkPercentageCortexA710L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKICortexA710INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKICortexA710L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKICortexA710L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKICortexA710INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA710L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA710L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA710L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA710INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA710L1D_CACHE_REFILL / $L1DCacheMPKICortexA710INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA710L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA710L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA710L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA710INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA710L1D_TLB_REFILL / $L1DataTLBMPKICortexA710INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA710L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA710L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA710L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA710INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA710L1I_CACHE_REFILL / $L1ICacheMPKICortexA710INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA710L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA710L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA710L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA710INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA710L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA710INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA710L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA710L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA710L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA710INST_RETIRED &gt; 0), (($L2CacheMPKICortexA710L2D_CACHE_REFILL / $L2CacheMPKICortexA710INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA710L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA710L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA710L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA710INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA710L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA710INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKICortexA710INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKICortexA710L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKICortexA710L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKICortexA710INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA710L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA710L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA710L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA710INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA710L2D_CACHE_REFILL / $L2DCacheMPKICortexA710INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA710L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA710L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA710L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA710INST_RETIRED &gt; 0), (($L3CacheMPKICortexA710L3D_CACHE_REFILL / $L3CacheMPKICortexA710INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA710INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA710LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA710INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA710LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA710LL_CACHE_RD - $LLCacheReadHitPercentageCortexA710LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA710LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA710LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA710LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA710LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA710INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA710LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA710INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA710INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA710LD_SPEC / $LoadOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Non-SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by an instruction that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($NonSVEFloatingPointOperationsPerCycleCortexA710CPU_CYCLES &gt; 0), ($NonSVEFloatingPointOperationsPerCycleCortexA710FP_FIXED_OPS_SPEC / $NonSVEFloatingPointOperationsPerCycleCortexA710CPU_CYCLES), 0)" name="Non-SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA710INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA710RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA710INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA710INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA710RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA710INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA710OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA710OP_RETIRED / $RetiredOperationsPercentageCortexA710OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA710CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA710OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA710STALL_SLOT / ($RetiringCortexA710CPU_CYCLES * 5))) * ($RetiringCortexA710OP_RETIRED / $RetiringCortexA710OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA710INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA710VFP_SPEC / $FloatingPointOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA710INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA710ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA710INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA710ST_SPEC / $StoreOperationsPercentageCortexA710INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexA710INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexA710STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexA710INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageCortexA710STREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageCortexA710STREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageCortexA710STREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA710INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA710STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA710INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations (Load/Store Inclusive) Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexA710INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexA710SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexA710INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by SVE instructions. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($SVEFloatingPointOperationsPerCycleCortexA710CPU_CYCLES &gt; 0), ($SVEFloatingPointOperationsPerCycleCortexA710FP_SCALE_OPS_SPEC / $SVEFloatingPointOperationsPerCycleCortexA710CPU_CYCLES), 0)" name="SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Empty Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with no active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEEmptyPredicatePercentageCortexA710SVE_PRED_SPEC &gt; 0), min(($SVEEmptyPredicatePercentageCortexA710SVE_PRED_EMPTY_SPEC / $SVEEmptyPredicatePercentageCortexA710SVE_PRED_SPEC), 1), 0)" name="SVE Empty Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Full Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with all active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEFullPredicatePercentageCortexA710SVE_PRED_SPEC &gt; 0), min(($SVEFullPredicatePercentageCortexA710SVE_PRED_FULL_SPEC / $SVEFullPredicatePercentageCortexA710SVE_PRED_SPEC), 1), 0)" name="SVE Full Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Partial Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with at least one active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEPartialPredicatePercentageCortexA710SVE_PRED_SPEC &gt; 0), min(($SVEPartialPredicatePercentageCortexA710SVE_PRED_PARTIAL_SPEC / $SVEPartialPredicatePercentageCortexA710SVE_PRED_SPEC), 1), 0)" name="SVE Partial Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with predicates as a percentage of operations speculatively executed" expression="if(($SVEPredicatePercentageCortexA710INST_SPEC &gt; 0), min(($SVEPredicatePercentageCortexA710SVE_PRED_SPEC / $SVEPredicatePercentageCortexA710INST_SPEC), 1), 0)" name="SVE Predicate Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A710_metric_backend_bound" />
    <select-metric id="ARMv8_Cortex_A710_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Cortex_A710_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A710_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A710_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp16_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp32_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp64_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Cortex_A710_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A710_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A710_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_nonsve_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Cortex_A710_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Cortex_A710_metric_retiring" />
    <select-metric id="ARMv8_Cortex_A710_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_strex_fail_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_strex_fail_percent" />
    <select-metric id="ARMv8_Cortex_A710_metric_strex_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_all_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_predicate_empty_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_predicate_full_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_predicate_partial_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_predicate_percentage" />
</template>
